import java.lang.Exception;
import java.sql.*;
import java.util.*;
import java.lang.Class;

class TestDataBase 
{
	public static void main(String[] args) 
	{
		String sURL = "jdbc:odbc:Northwind";
		String sUserID = "kevinbu";
		String sPassword = "";
		String sQuery = "SELECT EmployeeID, LastName, FirstName, Title FROM Employees";
		Connection con = null;
		Statement stmt = null;
		try
		{
			Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
			con = DriverManager.getConnection ( sURL,
				sUserID,
				sPassword);

			DatabaseMetaData dbmd = con.getMetaData();
			System.out.println(
				"DBMS: " + 
				dbmd.getDatabaseProductName()  + ", " +
				dbmd.getDatabaseProductVersion() );

			System.out.println(
				"Driver: " + 
				dbmd.getDriverName()  + ", " +
				dbmd.getDriverVersion() );

			stmt = con.createStatement();
		}
		catch ( SQLException SQLe)
		{
			System.err.println( "Problem z poczeniem do " +
				sURL + ":" );
			System.err.println( SQLe.getMessage() );
			System.err.println( "Stan SQL: " + 
				SQLe.getSQLState() );

			if( con != null)
			{
				try { con.close(); }
				catch( Exception e ) {}
			}

			return;
		} // end catch
		catch ( ClassNotFoundException CSFe)
		{
			System.err.println( "Nie odnaleziono klasy: " + CSFe.getMessage() );
		}
		try
		{
			ResultSet rs;
			ResultSetMetaData rsmd;
			rs = stmt.executeQuery( sQuery );
			rsmd = rs.getMetaData();
			int i = rsmd.getColumnCount();
			for( int ndx = 1; ndx <= i; ndx++ )
			{
				System.out.println(
					"Nazwa kolumny: " + 
					rsmd.getColumnName( ndx ) + "." );
				System.out.println(
					"Typ SQL kolumny: " + 
					rsmd.getColumnTypeName( ndx ) + "." );
				System.out.println(
					"Ekwiwalent klasy Java: " + 
					rsmd.getColumnClassName( ndx ) + ".\n" );
			}
			while( rs.next() )
			{
				System.out.println(rs.getInt("EmployeeID") + " " +
					               rs.getString("LastName") +  " " +
					               rs.getString("FirstName") +  " " +
					               rs.getString("Title"));
			} // end if( result.next() )
		}
		catch (Exception e)
		{ 
			e.printStackTrace(); 
		}
		finally
		{
			try
			{
				stmt.close();
			}
			catch( Exception e )
			{
			}

			try
			{
				con.close();
			}
			catch( Exception e )
			{
			}
		}
	}
}